% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{difference.igraph.vs}
\alias{difference.igraph.vs}
\title{Difference of vertex sequences}
\usage{
\method{difference}{igraph.vs}(big, small, ...)
}
\arguments{
\item{big}{The \sQuote{big} vertex sequence.}

\item{small}{The \sQuote{small} vertex sequence.}

\item{...}{Ignored, included for S3 signature compatibility.}
}
\value{
A vertex sequence that contains only vertices that are part of
\code{big}, but not part of \code{small}.
}
\description{
Difference of vertex sequences
}
\details{
They must belong to the same graph. Note that this function has
\sQuote{set} semantics and the multiplicity of vertices is lost in the
result.
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
difference(V(g), V(g)[6:10])
}
\seealso{
Other vertex and edge sequence operations: \code{\link{c.igraph.es}},
  \code{\link{c.igraph.vs}},
  \code{\link{difference.igraph.es}},
  \code{\link{igraph-es-indexing2}},
  \code{\link{igraph-es-indexing}},
  \code{\link{igraph-vs-indexing2}},
  \code{\link{igraph-vs-indexing}},
  \code{\link{intersection.igraph.es}},
  \code{\link{intersection.igraph.vs}},
  \code{\link{rev.igraph.es}}, \code{\link{rev.igraph.vs}},
  \code{\link{union.igraph.es}},
  \code{\link{union.igraph.vs}},
  \code{\link{unique.igraph.es}},
  \code{\link{unique.igraph.vs}}
}
