% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs.R
\name{sample_motifs}
\alias{sample_motifs}
\alias{graph.motifs.est}
\title{Graph motifs}
\usage{
sample_motifs(graph, size = 3, cut.prob = rep(0, size),
  sample.size = vcount(graph)/10, sample = NULL)
}
\arguments{
\item{graph}{Graph object, the input graph.}

\item{size}{The size of the motif, currently 3 and 4 are supported only.}

\item{cut.prob}{Numeric vector giving the probabilities that the search
graph is cut at a certain level. Its length should be the same as the size
of the motif (the \code{size} argument). By default no cuts are made.}

\item{sample.size}{The number of vertices to use as a starting point for
finding motifs. Only used if the \code{sample} argument is \code{NULL}.}

\item{sample}{If not \code{NULL} then it specifies the vertices to use as a
starting point for finding motifs.}
}
\value{
A numeric scalar, an estimate for the total number of motifs in
  the graph.
}
\description{
Graph motifs are small connected subgraphs with a well-defined
structure.  These functions search a graph for various motifs.
}
\details{
\code{sample_motifs} estimates the total number of motifs of a given
size in a graph based on a sample.
}
\examples{
g <- barabasi.game(100)
motifs(g, 3)
count_motifs(g, 3)
sample_motifs(g, 3)
}
\seealso{
\code{\link{isomorphism_class}}

Other graph motifs: \code{\link{count_motifs}},
  \code{\link{motifs}}
}
