% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_sbm}
\alias{sample_sbm}
\alias{sbm.game}
\alias{sbm}
\title{Sample stochastic block model}
\usage{
sample_sbm(n, pref.matrix, block.sizes, directed = FALSE, loops = FALSE)
}
\arguments{
\item{n}{Number of vertices in the graph.}

\item{pref.matrix}{The matrix giving the Bernoulli rates.  This is a
\eqn{K\times K}{KxK} matrix, where \eqn{K} is the number of groups. The
probability of creating an edge between vertices from groups \eqn{i} and
\eqn{j} is given by element \eqn{(i,j)}. For undirected graphs, this matrix
must be symmetric.}

\item{block.sizes}{Numeric vector giving the number of vertices in each
group. The sum of the vector must match the number of vertices.}

\item{directed}{Logical scalar, whether to generate a directed graph.}

\item{loops}{Logical scalar, whether self-loops are allowed in the graph.}

\item{\dots}{Passed to \code{sample_sbm}.}
}
\value{
An igraph graph.
}
\description{
Sampling from the stochastic block model of networks
}
\details{
This function samples graphs from a stochastic block model by (doing the
equivalent of) Bernoulli trials for each potential edge with the
probabilities given by the Bernoulli rate matrix, \code{pref.matrix}.
}
\examples{

## Two groups with not only few connection between groups
pm <- cbind( c(.1, .001), c(.001, .05) )
g <- sample_sbm(1000, pref.matrix=pm, block.sizes=c(300,700))
g
}
\references{
Faust, K., & Wasserman, S. (1992a). Blockmodels: Interpretation
and evaluation. \emph{Social Networks}, 14, 5--61.
}
\seealso{
\code{\link{sample_gnp}}, \code{\link{sample_gnm}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
