% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{print.igraph.vs}
\alias{print.igraph.vs}
\title{Show a vertex sequence on the screen}
\usage{
\method{print}{igraph.vs}(x, full = igraph_opt("print.full"), ...)
}
\arguments{
\item{x}{A vertex sequence.}

\item{full}{Whether to show the full sequence, or truncate the output
to the screen size.}

\item{...}{These arguments are currently ignored.}
}
\value{
The vertex sequence, invisibly.
}
\description{
For long vertex sequences, the printing is truncated to fit to the 
screen. Use \code{print} explicitly and the \code{full} argument to
see the full sequence.
}
\details{
Vertex sequence created with the double bracket operator are
printed differently, together with all attributes of the vertices
in the sequence, as a table.
}
\examples{
# Unnamed graphs
g <- make_ring(10)
V(g)

# Named graphs
g2 <- make_ring(10) \%>\%
  set_vertex_attr("name", value = LETTERS[1:10])
V(g2)

# All vertices in the sequence
g3 <- make_ring(1000)
V(g3)
print(V(g3), full = TRUE)

# Metadata
g4 <- make_ring(10) \%>\%
  set_vertex_attr("name", value = LETTERS[1:10]) \%>\%
  set_vertex_attr("color", value = "red")
V(g4)[[]]
V(g4)[[2:5, 7:8]]
}
\seealso{
Other vertex and edge sequences: \code{\link{E}},
  \code{\link{V}}, \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-indexing2}},
  \code{\link{igraph-es-indexing}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-indexing2}},
  \code{\link{igraph-vs-indexing}},
  \code{\link{print.igraph.es}}
}
\concept{vertex and edge sequences}
