% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.R
\name{each_edge}
\alias{each_edge}
\title{Rewires the endpoints of the edges of a graph to a random vertex}
\usage{
each_edge(prob, loops = FALSE, multiple = FALSE)
}
\arguments{
\item{prob}{The rewiring probability, a real number between zero and one.}

\item{loops}{Logical scalar, whether loop edges are allowed in the rewired
graph.}

\item{multiple}{Logical scalar, whether multiple edges are allowed int the
generated graph.}
}
\description{
This function can be used together with \code{\link{rewire}}.
This method rewires the endpoints of the edges with a constant probability
uniformly randomly to a new vertex in a graph.
}
\details{
Note that this method might create graphs with multiple and/or loop edges.
}
\examples{

# Some random shortcuts shorten the distances on a lattice
g <- make_lattice(length = 100, dim = 1, nei = 5)
mean_distance(g)
g <- rewire(g, each_edge(prob = 0.05))
mean_distance(g)
}
\seealso{
Other rewiring functions: \code{\link{keeping_degseq}},
  \code{\link{rewire}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{rewiring functions}
\keyword{graphs}
