% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_edgelist}
\alias{as_edgelist}
\alias{get.edgelist}
\title{Convert a graph to an edge list}
\usage{
as_edgelist(graph, names = TRUE)
}
\arguments{
\item{graph}{The graph to convert.}

\item{names}{Whether to return a character matrix containing vertex
names (i.e. the \code{name} vertex attribute) if they exist or numeric
vertex ids.}
}
\value{
A \code{ecount(graph)} by 2 numeric matrix.
}
\description{
Sometimes it is useful to work with a standard representation of a
graph, like an edge list.
}
\details{
\code{as_edgelist()} returns the list of edges in a graph.
}
\examples{

g <- sample_gnp(10, 2 / 10)
as_edgelist(g)

V(g)$name <- LETTERS[seq_len(gorder(g))]
as_edgelist(g)

}
\seealso{
\code{\link[=graph_from_adjacency_matrix]{graph_from_adjacency_matrix()}}, \code{\link[=read_graph]{read_graph()}}

Other conversion: 
\code{\link{as.directed}()},
\code{\link{as.matrix.igraph}()},
\code{\link{as_adj_list}()},
\code{\link{as_adjacency_matrix}()},
\code{\link{as_biadjacency_matrix}()},
\code{\link{as_data_frame}()},
\code{\link{as_graphnel}()},
\code{\link{as_long_data_frame}()},
\code{\link{graph_from_adj_list}()},
\code{\link{graph_from_graphnel}()}
}
\concept{conversion}
\keyword{graphs}
