% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{intersection.igraph}
\alias{intersection.igraph}
\alias{graph.intersection}
\alias{\%s\%}
\title{Intersection of graphs}
\usage{
\method{intersection}{igraph}(..., byname = "auto", keep.all.vertices = TRUE)
}
\arguments{
\item{\dots}{Graph objects or lists of graph objects.}

\item{byname}{A logical scalar, or the character scalar \code{auto}. Whether
to perform the operation based on symbolic vertex names. If it is
\code{auto}, that means \code{TRUE} if all graphs are named and \code{FALSE}
otherwise. A warning is generated if \code{auto} and some (but not all)
graphs are named.}

\item{keep.all.vertices}{Logical scalar, whether to keep vertices that only
appear in a subset of the input graphs.}
}
\value{
A new graph object.
}
\description{
The intersection of two or more graphs are created.  The graphs may have
identical or overlapping vertex sets.
}
\details{
\code{intersection()} creates the intersection of two or more graphs:
only edges present in all graphs will be included.  The corresponding
operator is \verb{\%s\%}.

If the \code{byname} argument is \code{TRUE} (or \code{auto} and all graphs
are named), then the operation is performed on symbolic vertex names instead
of the internal numeric vertex ids.

\code{intersection()} keeps the attributes of all graphs. All graph,
vertex and edge attributes are copied to the result. If an attribute is
present in multiple graphs and would result a name clash, then this
attribute is renamed by adding suffixes: _1, _2, etc.

The \code{name} vertex attribute is treated specially if the operation is
performed based on symbolic vertex names. In this case \code{name} must be
present in all graphs, and it is not renamed in the result graph.

An error is generated if some input graphs are directed and others are
undirected.
}
\examples{

## Common part of two social networks
net1 <- graph_from_literal(
  D - A:B:F:G, A - C - F - A, B - E - G - B, A - B, F - G,
  H - F:G, H - I - J
)
net2 <- graph_from_literal(D - A:F:Y, B - A - X - F - H - Z, F - Y)
print_all(net1 \%s\% net2)
}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{complementer}()},
\code{\link{compose}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference.igraph}()},
\code{\link{difference}()},
\code{\link{disjoint_union}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection}()},
\code{\link{path}()},
\code{\link{permute}()},
\code{\link{rep.igraph}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union.igraph}()},
\code{\link{union}()},
\code{\link{vertex}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{functions for manipulating graph structure}
\keyword{graphs}
