% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{bonpow}
\alias{bonpow}
\title{Find Bonacich Power Centrality Scores of Network Positions}
\usage{
bonpow(
  graph,
  nodes = V(graph),
  loops = FALSE,
  exponent = 1,
  rescale = FALSE,
  tol = 1e-07,
  sparse = TRUE
)
}
\arguments{
\item{graph}{the input graph.}

\item{nodes}{vertex sequence indicating which vertices are to be included in
the calculation.  By default, all vertices are included.}

\item{loops}{boolean indicating whether or not the diagonal should be
treated as valid data.  Set this true if and only if the data can contain
loops.  \code{loops} is \code{FALSE} by default.}

\item{exponent}{exponent (decay rate) for the Bonacich power centrality
score; can be negative}

\item{rescale}{if true, centrality scores are rescaled such that they sum to
1.}

\item{tol}{tolerance for near-singularities during matrix inversion (see
\code{\link[=solve]{solve()}})}

\item{sparse}{Logical scalar, whether to use sparse matrices for the
calculation. The \sQuote{Matrix} package is required for sparse matrix
support}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{bonpow()} was renamed to \code{power_centrality()} to create a more
consistent API.
}
\keyword{internal}
