% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{fastgreedy.community}
\alias{fastgreedy.community}
\title{Community structure via greedy optimization of modularity}
\usage{
fastgreedy.community(
  graph,
  merges = TRUE,
  modularity = TRUE,
  membership = TRUE,
  weights = NULL
)
}
\arguments{
\item{graph}{The input graph. It must be undirected and must not have
multi-edges.}

\item{merges}{Logical scalar, whether to return the merge matrix.}

\item{modularity}{Logical scalar, whether to return a vector containing the
modularity after each merge.}

\item{membership}{Logical scalar, whether to calculate the membership vector
corresponding to the maximum modularity score, considering all possible
community structures along the merges.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{fastgreedy.community()} was renamed to \code{cluster_fast_greedy()} to create a more
consistent API.
}
\keyword{internal}
