% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_drl.R
\name{layout.drl}
\alias{layout.drl}
\title{The DrL graph layout generator}
\usage{
layout.drl(
  graph,
  use.seed = FALSE,
  seed = matrix(runif(vcount(graph) * 2), ncol = 2),
  options = drl_defaults$default,
  weights = NULL,
  dim = 2
)
}
\arguments{
\item{graph}{The input graph, in can be directed or undirected.}

\item{use.seed}{Logical scalar, whether to use the coordinates given in the
\code{seed} argument as a starting point.}

\item{seed}{A matrix with two columns, the starting coordinates for the
vertices is \code{use.seed} is \code{TRUE}. It is ignored otherwise.}

\item{options}{Options for the layout generator, a named list. See details
below.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for the layout. Larger edge weights
correspond to stronger connections.}

\item{dim}{Either \sQuote{2} or \sQuote{3}, it specifies whether we want a
two dimensional or a three dimensional layout. Note that because of the
nature of the DrL algorithm, the three dimensional layout takes
significantly longer to compute.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{layout.drl()} was renamed to \code{layout_with_drl()} to create a more
consistent API.
}
\keyword{internal}
