% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{unique.igraph.vs}
\alias{unique.igraph.vs}
\title{Remove duplicate vertices from a vertex sequence}
\usage{
\method{unique}{igraph.vs}(x, incomparables = FALSE, ...)
}
\arguments{
\item{x}{A vertex sequence.}

\item{incomparables}{a vector of values that cannot be compared.
Passed to base function \code{duplicated}. See details there.}

\item{...}{Passed to base function \code{duplicated()}.}
}
\value{
A vertex sequence with the duplicate vertices removed.
}
\description{
Remove duplicate vertices from a vertex sequence
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
V(g)[1, 1:5, 1:10, 5:10]
V(g)[1, 1:5, 1:10, 5:10] \%>\% unique()
}
\seealso{
Other vertex and edge sequence operations: 
\code{\link{c.igraph.es}()},
\code{\link{c.igraph.vs}()},
\code{\link{difference.igraph.es}()},
\code{\link{difference.igraph.vs}()},
\code{\link{igraph-es-indexing}},
\code{\link{igraph-es-indexing2}},
\code{\link{igraph-vs-indexing}},
\code{\link{igraph-vs-indexing2}},
\code{\link{intersection.igraph.es}()},
\code{\link{intersection.igraph.vs}()},
\code{\link{rev.igraph.es}()},
\code{\link{rev.igraph.vs}()},
\code{\link{union.igraph.es}()},
\code{\link{union.igraph.vs}()},
\code{\link{unique.igraph.es}()}
}
\concept{vertex and edge sequence operations}
