# igraph/src

## Updating the C sources

1. Check out and update the `cigraph` submodule to the desired version.
    ```sh
    git submodule init
    git submodule update
    # other git submodule commands to update the submodule to the desired version
    ```
2. Clean the `src/` directory:
    ```sh
    make -f Makefile-cigraph clean
    ```
3. Update the `src/` directory:
    ```sh
    make -f Makefile-cigraph
    ```

    Note that this may change files generated by `flex` and `bison`, and configure scripts, depending on the version of those tools.
    For stability, you can use a Docker image that uses pinned versions of these tools:
    ```sh
    docker run --rm -ti --platform linux/amd64 -v $(pwd):/root/workspace ghcr.io/cynkra/rig-ubuntu-igraph:main make -f Makefile-cigraph
    ```

4. Commit and push
5. Optional: Clean submodule
    ```sh
    git submodule deinit --all
    ```
