% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{allowVariables}
\alias{allowVariables}
\title{Allow variable assignment without authorization}
\usage{
allowVariables(vars = NULL)
}
\arguments{
\item{vars}{Vector of variable names to be added to the list. If \code{NULL},
returns names of all currently allowed variables.}
}
\value{
Names of all currently allowed variables if \code{vars = NULL}.
}
\description{
This function adds variable names to the list of variables, that
can be modified from a web page without manual confirmation on the R side.
}
\details{
This function is a wrapper around \code{allowVariables} method of class \code{\link{App}}.
}
\examples{
\donttest{openPage()
allowVariables(c("myVariable", "anotherOne"))
vars <- allowVariables()
closePage()}

}
\seealso{
\code{\link{allowFunctions}}, \code{\link{authorize}}, \code{\link{openPage}} (check argument
\code{allowedVariables}), \code{\link{sendData}}.
}
