% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_indent.R
\name{add_indent}
\alias{add_indent}
\title{Add indentations to row headers}
\usage{
add_indent(
  kable_input,
  positions,
  level_of_indent = 1,
  all_cols = FALSE,
  target_cols = 1
)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{positions}{A vector of numeric row numbers for the rows that need to
be indented.}

\item{level_of_indent}{a numeric value for the indent level. Default is 1.}

\item{all_cols}{T/F whether to apply indentation to all columns}

\item{target_cols}{A vector of numeric column positions. Default is 1.}
}
\description{
Add indentations to row headers
}
\examples{
\dontrun{
x <- knitr::kable(head(mtcars), "html")
# Add indentations to the 2nd & 4th row
add_indent(x, c(2, 4), level_of_indent = 1)
}

}
