% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.backup.R
\name{file.backup}
\alias{file.backup}
\title{Create a backup version of a file by renaming it.}
\usage{
file.backup(name, fullpath = FALSE, keep.old = FALSE, verbose = FALSE)
}
\arguments{
\item{name}{A character string for the name of the file.}

\item{fullpath}{Return the full directory path to the
file. Default FALSE, return only the file name.}

\item{keep.old}{If FALSE (default), rename the file. Otherwise, keep old copy.}

\item{verbose}{If TRUE, output warnings and list the files in the output directory when done.}
}
\value{
The name of the newly created file.
}
\description{
Inserts the date-time of the most recent modification at the
end of the file name, before the extension.
}
\details{
Return is the new file name that was created, using whatever
path information was provided in the file's original name. However,
the fullpath argument can be set to TRUE, so a path with the
full directory name will be created and returned.
}
\examples{
tdir <- tempdir()
owd <- getwd()

setwd(tdir)
system("touch test.1.txt")
system("touch test.2.txt")
system("touch test.3.txt")
system("touch test.4.txt")
system("touch test.5.txt")
## note: no extension next
system("touch test.6")
list.files()
file.backup("test.1.txt")
file.backup("test.2.txt", fullpath=TRUE)
list.files()
setwd(owd)
file.backup(file.path(tdir, "test.3.txt"))
## Next should be same path because input had a full path
file.backup(file.path(tdir, "test.4.txt"), fullpath=TRUE)
file.backup(file.path(tdir, "test.5.txt"), fullpath = TRUE, verbose = TRUE)
file.backup(file.path(tdir, "test.6"))
}
\author{
Shadi Pirhosseinloo <shadi@ku.edu> Paul Johnson <pauljohn@ku.edu>
}
