% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{keyLookup}
\alias{keyLookup}
\title{Look for old (or new) names in variable key}
\usage{
keyLookup(x, key, get = "name_old")
}
\arguments{
\item{x}{A variable name. If \code{get = "name_old"}, then
\code{x} is a value for \code{name_new}. If \code{get =
"name_new"}, \code{x} should be a value for \code{name_old}.}

\item{key}{Which key should be used}

\item{get}{Either "name_old" (to retrieve the original name) or
"name_new" (to get the new name)}
}
\value{
A vector or list of matches between x and either name_new
    or name_old elements in the key.
}
\description{
Use the key to find the original name of a variable that has been
renamed, or find the new name of an original variable.  The
\code{get} argument indicates if the \code{name_old} or
\code{name_new} is desired.
}
\details{
If \code{get = "name_old"}, the return is a character vector, with
one element per value of \code{x}.  If there is no match for a
value of \code{x}, the value NA is returned for that
value. However, if \code{get = "name_new"}, the return might be
either a vector (one element per value of \code{x}) or a list with
one element for each value of \code{x}.  The list is returned when
a value of \code{x} corresponds to more than one element in
\code{name_old}.
}
\examples{
mydf.key.path <- system.file("extdata", "mydf.key.csv", package = "kutils")
mydf.key <-  keyImport(mydf.key.path)
mydf.key$name_new <- paste0("new_", mydf.key$name_new)
keyLookup("new_x5", mydf.key, get = "name_old")
keyLookup(c("new_x6", "new_x1"), mydf.key, get = "name_old")
keyLookup(c("x6", "x1"), mydf.key, get = "name_new")
keyLookup(c("asdf", "new_x1"), mydf.key, get = "name_old")

mydf.key <- rbind(mydf.key,
                 c("x3", "x3f",  "ordered", "factor", "","","",""))
keyLookup(c("x3"), mydf.key, get = "name_new")
keyLookup(c("x1", "x3", "x5"), mydf.key, get = "name_new")
}
\author{
Paul Johnson
}
