% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backdoor.R
\name{backdoor}
\alias{backdoor}
\title{Backdoor criterion}
\usage{
backdoor(object, f, cond, ..., return.graph = FALSE)
}
\arguments{
\item{object}{lvm object}

\item{f}{formula. Conditioning, z, set can be given as y~x|z}

\item{cond}{Vector of variables to conditon on}

\item{...}{Additional arguments to lower level functions}

\item{return.graph}{Return moral ancestral graph with z and effects from x removed}
}
\description{
Check backdoor criterion of a lvm object
}
\examples{
m <- lvm(y~c2,c2~c1,x~c1,m1~x,y~m1, v1~c3, x~c3,v1~y,
         x~z1, z2~z1, z2~z3, y~z3+z2+g1+g2+g3)
ll <- backdoor(m, y~x)
backdoor(m, y~x|c1+z1+g1)
}
