% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_length_linter.R
\name{object_length_linter}
\alias{object_length_linter}
\title{Object length linter}
\usage{
object_length_linter(length = 30L)
}
\arguments{
\item{length}{maximum variable name length allowed.}
}
\description{
Check that object names are not too long.
The length of an object name is defined as the length in characters, after removing extraneous parts:
}
\details{
\itemize{
\item generic prefixes for implementations of S3 generics, e.g. \code{as.data.frame.my_class} has length 8.
\item leading \code{.}, e.g. \code{.my_hidden_function} has length 18.
\item "\%\%" for infix operators, e.g. \verb{\%my_op\%} has length 5.
\item trailing \verb{<-} for assignment functions, e.g. \verb{my_attr<-} has length 7.
}

Note that this behavior relies in part on having packages in your Imports available;
see the detailed note in \code{\link[=object_name_linter]{object_name_linter()}} for more details.
}
\examples{
# will produce lints
lint(
  text = "very_very_long_variable_name <- 1L",
  linters = object_length_linter(length = 10L)
)

# okay
lint(
  text = "very_very_long_variable_name <- 1L",
  linters = object_length_linter(length = 30L)
)

lint(
  text = "var <- 1L",
  linters = object_length_linter(length = 10L)
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=executing_linters]{executing}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
