% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmer.R
\name{as_lmerModLmerTest}
\alias{as_lmerModLmerTest}
\title{Coerce lmerMod Objects to lmerModLmerTest}
\usage{
as_lmerModLmerTest(model, tol = 1e-08)
}
\arguments{
\item{model}{and lmer model-object (of class 'lmerMod') -- the result of a
call to \code{lme4::lmer()}}

\item{tol}{tolerance for determining of eigenvalues are negative, zero or
positive}
}
\value{
an object of class \code{'lmerModLmerTest'} which sets the following
slots:
\item{vcov_varpar}{the asymptotic covariance matrix of the variance parameters
(theta, sigma).}
\item{Jac_list}{list of Jacobian matrices; gradients of vcov(beta) with
respect to the variance parameters.}
\item{vcov_beta}{the asymptotic covariance matrix of the fixed-effect
regression parameters (beta; vcov(beta)).}
\item{sigma}{the residual standard deviation.}
}
\description{
Coercing an lme4::lmer model-object (of class 'lmerMod') to a model-object
of class 'lmerModLmerTest' involves computing the covariance
matrix of the variance parameters and the gradient (Jacobian) of cov(beta)
with respect to the variance parameters.
}
\examples{
m <- lme4::lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
bm <- as_lmerModLmerTest(m)
slotNames(bm)

}
\seealso{
the class definition in \code{\link{lmerModLmerTest}}) and
\code{\link{lmer}}
}
\author{
Rune Haubo B. Christensen
}
