% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appenders.R
\name{appender_slack}
\alias{appender_slack}
\title{Send log messages to a Slack channel}
\usage{
appender_slack(
  channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  api_token = Sys.getenv("SLACK_API_TOKEN"),
  preformatted = TRUE
)
}
\arguments{
\item{channel}{Slack channel name with a hashtag prefix for public channel and no prefix for private channels}

\item{username}{Slack (bot) username}

\item{icon_emoji}{optional override for the bot icon}

\item{api_token}{Slack API token}

\item{preformatted}{use code tags around the message?}
}
\value{
function taking \code{lines} argument
}
\description{
Send log messages to a Slack channel
}
\note{
This functionality depends on the \pkg{slackr} package.
}
\seealso{
This is generator function for \code{\link{log_appender}}, for alternatives, see eg \code{\link{appender_console}}, \code{\link{appender_file}}, \code{\link{appender_tee}}, \code{\link{appender_pushbullet}}, \code{\link{appender_telegram}}, \code{\link{appender_syslog}}, \code{\link{appender_kinesis}} and \code{\link{appender_async}} for evaluate any \code{\link{log_appender}} function in a background process.
}
