% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.r
\name{DateTimeUpdate}
\alias{DateTimeUpdate}
\alias{update.POSIXt}
\title{Changes the components of a date object}
\usage{
\method{update}{POSIXt}(object, ..., roll = FALSE,
  week_start = getOption("lubridate.week.start", 7), simple = NULL)
}
\arguments{
\item{object}{a date-time object}

\item{...}{named arguments: years, months, ydays, wdays, mdays, days, hours,
minutes, seconds, tzs (time zone compnent)}

\item{roll}{logical. If \code{TRUE}, and the resulting date-time lands on a
non-existent civil time instant (DST, 29th February, etc.) roll the date
till next valid point. When \code{FALSE}, the default, produce NA for non
existing date-times.}

\item{week_start}{week starting day (Default is 7, Sunday). Set
\code{lubridate.week.start} option to control this.}

\item{simple}{logical. Deprecated. Same as \code{roll}.}
}
\value{
a date object with the requested elements updated. The object will
retain its original class unless an element is updated which the original
class does not support. In this case, the date returned will be a POSIXlt
date object.
}
\description{
\code{update.Date()} and \code{update.POSIXt()} return a date with the specified
elements updated.  Elements not specified will be left unaltered. update.Date
and update.POSIXt do not add the specified values to the existing date, they
substitute them for the appropriate parts of the existing date.
}
\examples{
date <- ymd("2009-02-10")
update(date, year = 2010, month = 1, mday = 1)

update(date, year =2010, month = 13, mday = 1)

update(date, minute = 10, second = 3)
}
\keyword{chron}
\keyword{manip}
