% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{is.irreducible}
\alias{is.irreducible}
\title{Function to check if a Markov chain is irreducible (i.e. ergodic)}
\usage{
is.irreducible(object)
}
\arguments{
\item{object}{A \code{markovchain} object}
}
\value{
A boolean values.
}
\description{
This function verifies whether a \code{markovchain} object transition matrix 
             is composed by only one communicating class.
}
\details{
It is based on \code{.communicatingClasses} internal function.
}
\examples{
statesNames <- c("a", "b")
mcA <- new("markovchain", transitionMatrix = matrix(c(0.7,0.3,0.1,0.9),
                                             byrow = TRUE, nrow = 2, 
                                             dimnames = list(statesNames, statesNames)
           ))
is.irreducible(mcA)

}
\references{
Feres, Matlab listings for Markov Chains.
}
\seealso{
\code{\link{summary}}
}
\author{
Giorgio Spedicato
}
