% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.regression.R
\name{binregATE}
\alias{binregATE}
\alias{logitIPCWATE}
\alias{logitATE}
\alias{normalATE}
\alias{kumarsim}
\alias{kumarsimRCT}
\title{Average Treatment effect for censored competing risks data using Binomial Regression}
\usage{
binregATE(
  formula,
  data,
  cause = 1,
  time = NULL,
  beta = NULL,
  treat.model = ~+1,
  cens.model = ~+1,
  offset = NULL,
  weights = NULL,
  cens.weights = NULL,
  se = TRUE,
  type = c("II", "I"),
  kaplan.meier = TRUE,
  cens.code = 0,
  no.opt = FALSE,
  method = "nr",
  augmentation = NULL,
  outcome = c("cif", "rmst"),
  model = "exp",
  Ydirect = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{cause of interest}

\item{time}{time of interest}

\item{beta}{starting values}

\item{treat.model}{logistic treatment model given covariates}

\item{cens.model}{only stratified cox model without covariates}

\item{offset}{offsets for partial likelihood}

\item{weights}{for score equations}

\item{cens.weights}{censoring weights}

\item{se}{to compute se's with IPCW  adjustment, otherwise assumes that IPCW weights are known}

\item{type}{"II" adds augmentation term, and "I" classic binomial regression}

\item{kaplan.meier}{uses Kaplan-Meier for IPCW in contrast to exp(-Baseline)}

\item{cens.code}{gives censoring code}

\item{no.opt}{to not optimize}

\item{method}{for optimization}

\item{augmentation}{for augment binomial regression}

\item{outcome}{can do CIF regression "cif"=F(t|X), "rmst"=E( min(T, t) | X) , or E( I(epsilon==cause) ( t - mint(T,t)) ) | X) depending on the number of the number of causes.}

\item{model}{exp or linear model for E( min(T, t) | X)=exp(X^t beta), or E( I(epsilon==cause) ( t - mint(T,t)) ) | X)=exp(X^t beta)}

\item{Ydirect}{use this outcome Y with IPCW vesion}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Under the standard causal assumptions  we can estimate the average treatment effect E(Y(1) - Y(0)). We need Consistency, ignorability ( Y(1), Y(0) indep A given X), and positivity.
}
\details{
The first covariate in the specification of the competing risks regression model must be the treatment effect that is a factor. If the factor has more than two levels
then it uses the mlogit for propensity score modelling. If there are no censorings this is the same as ordinary logistic regression modelling. 

Estimates the ATE using the the standard binary double robust estimating equations that are IPCW censoring adjusted.
Rather than binomial regression we also consider a IPCW weighted version of standard logistic regression logitIPCWATE.
}
\examples{
data(bmt)
dfactor(bmt)  <-  ~.

brs <- binregATE(Event(time,cause)~tcell.f+platelet+age,bmt,time=50,cause=1,
  treat.model=tcell.f~platelet+age)
summary(brs)

brsi <- binregATE(Event(time,cause)~tcell.f+tcell.f*platelet+tcell.f*age,bmt,time=50,cause=1,
  treat.model=tcell.f~platelet+age)
summary(brsi)

}
\author{
Thomas Scheike
}
