/*
 * Decompiled with CFR 0.152.
 */
package mine.core;

import data.Point;
import data.VarPairData;
import java.io.IOException;
import mine.core.GridFinder;
import mine.core.MineParameters;

public class Manifold {
    private MineParameters p;
    private VarPairData xy1;
    private VarPairData xy2;
    private VarPairData yx1;
    private VarPairData yx2;
    private int maxNumBoxes;
    public float[][] scores;

    public Manifold(VarPairData xy_, MineParameters p_) {
        float[] results;
        this.p = p_;
        this.xy1 = xy_;
        this.xy1.sortByX();
        this.xy2 = new VarPairData(this.xy1, false);
        this.xy2.sortByY();
        this.yx2 = new VarPairData(this.xy1, true);
        this.yx1 = new VarPairData(this.xy2, true);
        this.maxNumBoxes = (int)Math.pow(this.xy1.data.length, this.p.maxNumBoxesExponent);
        this.maxNumBoxes = Math.max(this.maxNumBoxes, 4);
        if (this.p.debug >= 1) {
            try {
                this.p.debugOut.write("x range: " + this.xy1.minX + " to " + this.xy1.maxX + "\n");
                this.p.debugOut.write("y range: " + this.xy1.minY + " to " + this.xy1.maxY + "\n");
                this.p.debugOut.write("# common values = " + this.xy1.data.length + "\n");
                this.p.debugOut.write("max # boxes allowed = " + this.maxNumBoxes + "\n");
                this.p.debugOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.scores = new float[this.maxNumBoxes / 2 + 1][];
        int numBinsX = 2;
        while (numBinsX <= this.maxNumBoxes / 2) {
            this.scores[numBinsX] = new float[this.maxNumBoxes / numBinsX + 1];
            results = GridFinder.approxMaxMI(this.yx1.data, this.yx2.data, this.maxNumBoxes / numBinsX, numBinsX, this.p.numClumpsFactor, this.p.debug);
            int numBinsY = 2;
            while (numBinsY < this.scores[numBinsX].length) {
                this.scores[numBinsX][numBinsY] = results[numBinsY];
                ++numBinsY;
            }
            ++numBinsX;
        }
        int numBinsY = 2;
        while (numBinsY <= this.maxNumBoxes / 2) {
            results = GridFinder.approxMaxMI(this.xy1.data, this.xy2.data, this.maxNumBoxes / numBinsY, numBinsY, this.p.numClumpsFactor, this.p.debug);
            int numBinsX2 = 2;
            while (numBinsX2 <= this.maxNumBoxes / numBinsY) {
                this.scores[numBinsX2][numBinsY] = Math.max(this.scores[numBinsX2][numBinsY], results[numBinsX2]);
                ++numBinsX2;
            }
            ++numBinsY;
        }
        if (this.p.debug == 2) {
            try {
                this.p.debugOut.write("Truncated MI score manifold:\n");
                int i = 2;
                while (i < Math.min(this.scores.length, 10)) {
                    this.p.debugOut.write(String.valueOf(i) + "\t");
                    int j = 2;
                    while (j < Math.min(this.scores[i].length, 10)) {
                        this.p.debugOut.write(String.valueOf(this.scores[i][j]) + "\t");
                        ++j;
                    }
                    this.p.debugOut.newLine();
                    ++i;
                }
                this.p.debugOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.p.debug > 2) {
            try {
                this.p.debugOut.write("Complete MI score manifold:\n");
                int i = 2;
                while (i < this.scores.length) {
                    int j = 2;
                    while (j < this.scores[i].length) {
                        this.p.debugOut.write(String.valueOf(this.scores[i][j]) + "\t");
                        ++j;
                    }
                    this.p.debugOut.newLine();
                    ++i;
                }
                this.p.debugOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public float MIC(Point foundAt) {
        float maxVal = -3.4028235E38f;
        int maxValX = -1;
        int maxValY = -1;
        int x = 2;
        while (x < this.scores.length) {
            int y = 2;
            while (y < this.scores[x].length) {
                if (this.scores[x][y] > maxVal || this.scores[x][y] == maxVal && x * y < maxValX * maxValY) {
                    maxVal = this.scores[x][y];
                    maxValX = x;
                    maxValY = y;
                }
                ++y;
            }
            ++x;
        }
        foundAt.x = maxValX;
        foundAt.y = maxValY;
        return maxVal;
    }

    public float maxValueAlongRay(Point slope) {
        float m = slope.y / slope.x;
        float maxSoFar = -3.4028235E38f;
        int bx = -1;
        bx = 2;
        while (bx < this.scores.length) {
            int by = (int)m * bx;
            if (by >= this.scores[bx].length) break;
            if (this.scores[bx][by] > maxSoFar) {
                maxSoFar = this.scores[bx][by];
            }
            ++bx;
        }
        return maxSoFar;
    }

    public float MIC() {
        return this.MIC(new Point(Float.NaN, Float.NaN));
    }

    public float lastValueOfRay(Point slope) {
        float m = slope.y / slope.x;
        int bx = (int)Math.sqrt((float)this.maxNumBoxes / m);
        int by = this.maxNumBoxes / bx;
        if (bx < this.scores.length && by < this.scores[bx].length) {
            return this.scores[bx][by];
        }
        return -3.4028235E38f;
    }

    public float MAS(Point foundAt) {
        float antiSymmetry = 0.0f;
        float maxAntiSymmetry = -1.0f;
        int MASfoundX = -1;
        int MASfoundY = -1;
        int x = 2;
        while (x < this.scores.length) {
            int y = 2;
            while (y < this.scores[x].length) {
                if (y < this.scores.length && x < this.scores[y].length) {
                    float thisOne = this.scores[x][y] - this.scores[y][x];
                    antiSymmetry += Math.abs(thisOne);
                    if (thisOne > maxAntiSymmetry) {
                        maxAntiSymmetry = thisOne;
                        MASfoundX = x;
                        MASfoundY = y;
                    }
                }
                ++y;
            }
            ++x;
        }
        foundAt.x = MASfoundX;
        foundAt.y = MASfoundY;
        return maxAntiSymmetry;
    }

    public float MAS() {
        return this.MAS(new Point(Float.NaN, Float.NaN));
    }

    public float maxValueWithTwoRowsOrColumns() {
        float max = -3.4028235E38f;
        int i = 2;
        while (2 * i < this.maxNumBoxes) {
            if (this.scores[2][i] > max) {
                max = this.scores[2][i];
            }
            if (this.scores[i][2] > max) {
                max = this.scores[i][2];
            }
            ++i;
        }
        return max;
    }

    public float Complexity() {
        return this.maxValByProduct(1.0f);
    }

    public float maxValByProduct(float percentOfMax) {
        float max = this.MIC();
        float prodXYBins = Float.MAX_VALUE;
        int x = 2;
        while (x < this.scores.length) {
            int y = 2;
            while (y < this.scores[x].length) {
                if (this.scores[x][y] >= percentOfMax * max && (float)(x * y) < prodXYBins) {
                    prodXYBins = x * y;
                }
                ++y;
            }
            ++x;
        }
        return prodXYBins;
    }
}

