/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.AnalysisParameters;
import analysis.VarPairQueue;
import analysis.results.Result;
import data.Dataset;
import data.VarPairData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mine.core.MineParameters;

public class Analysis {
    private Dataset d;
    private VarPairQueue pairs;
    private ArrayList<Result> results;

    public Analysis(Dataset d_, VarPairQueue pairs_) {
        this.d = d_;
        this.pairs = pairs_;
        this.results = new ArrayList();
    }

    public VarPairQueue varPairQueue() {
        return this.pairs;
    }

    public int numResults() {
        return this.results.size();
    }

    public <R extends Result> void analyzePairs(Class<R> resultType, AnalysisParameters p) {
        this.analyzePairs(resultType, p, this.pairs.size());
    }

    public <R extends Result> void analyzePairs(Class<R> resultType, AnalysisParameters p, int maxNumPairsToAnalyze) {
        for (VarPairData varPairData : this.pairs.getVarPairDataList(maxNumPairsToAnalyze)) {
            this.results.add((Result)this.analyzeOnePair(resultType, varPairData, p.mineParams, p.commonValsThreshold));
            if (this.results.size() % p.gcWait != 0) continue;
            System.gc();
        }
    }

    public Result[] getSortedResults() {
        Result[] rVal = this.results.toArray(new Result[0]);
        Arrays.sort(rVal, Collections.reverseOrder());
        return rVal;
    }

    private <R extends Result> R analyzeOnePair(Class<R> resultType, VarPairData vp, MineParameters p, float commonValsThreshold) {
        if ((float)vp.sampleSize() >= (float)this.d.numRecords() * commonValsThreshold) {
            return Analysis.getResult(resultType, vp, p);
        }
        Result result = null;
        try {
            result = (Result)resultType.newInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        result.constructEmpty(vp);
        return (R)result;
    }

    public static <R extends Result> R getResult(Class<R> resultType, VarPairData vp, MineParameters p) {
        Result result = null;
        try {
            result = (Result)resultType.newInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        if (vp.sampleSize() > 0) {
            if (p.debug >= 1) {
                try {
                    p.debugOut.write("===\n" + vp.xVarName + " against " + vp.yVarName + "\tfirst few points:\n");
                    p.debugOut.flush();
                    int i = 0;
                    while (i < Math.min(vp.data.length, 4)) {
                        p.debugOut.write("(" + vp.data[i].x + ", " + vp.data[i].y + ")\n");
                        ++i;
                    }
                    p.debugOut.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            result.construct(vp, p);
            return (R)result;
        }
        result.constructEmpty(vp);
        return (R)result;
    }
}

