% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFilterValues.R
\name{generateFilterValuesData}
\alias{generateFilterValuesData}
\alias{FilterValues}
\title{Calculates feature filter values.}
\usage{
generateFilterValuesData(
  task,
  method = "FSelectorRcpp_information.gain",
  nselect = getTaskNFeats(task),
  ...,
  more.args = list()
)
}
\arguments{
\item{task}{(\link{Task})\cr
The task.}

\item{method}{(\link{character} | \link{list})\cr
Filter method(s).
In case of ensemble filters the \code{list} notation needs to be used.
See the examples for more information.
Default is \dQuote{FSelectorRcpp_information.gain}.}

\item{nselect}{(\code{integer(1)})\cr
Number of scores to request. Scores are getting calculated for all features
per default.}

\item{...}{(any)\cr
Passed down to selected method. Can only be use if \code{method} contains one
element.}

\item{more.args}{(named \link{list})\cr
Extra args passed down to filter methods. List elements are named with the
filter \code{method} name the args should be passed down to.
A more general and flexible option than \code{...}.
Default is empty list.}
}
\value{
(\link{FilterValues}). A \code{list} containing:
\item{task.desc}{[\link{TaskDesc})\cr
Task description.}
\item{data}{(\code{data.frame}) with columns:
\itemize{
\item \code{name}(\link{character})\cr
Name of feature.
\item \code{type}(\link{character})\cr
Feature column type.
\item \code{method}(\link{numeric})\cr
One column for each method with the feature importance values.
}}
}
\description{
Calculates numerical filter values for features.
For a list of features, use \link{listFilterMethods}.
}
\section{Simple and ensemble filters}{


Besides passing (multiple) simple filter methods you can also pass an
ensemble filter method (in a list). The ensemble method will use the simple
methods to calculate its ranking. See \code{listFilterEnsembleMethods()} for
available ensemble methods.
}

\examples{
# two simple filter methods
fval = generateFilterValuesData(iris.task,
  method = c("FSelectorRcpp_gain.ratio", "FSelectorRcpp_information.gain"))
# using ensemble method "E-mean"
fval = generateFilterValuesData(iris.task,
  method = list("E-mean", c("FSelectorRcpp_gain.ratio",
    "FSelectorRcpp_information.gain")))
}
\seealso{
Other generate_plot_data: 
\code{\link{generateCalibrationData}()},
\code{\link{generateCritDifferencesData}()},
\code{\link{generateFeatureImportanceData}()},
\code{\link{generateLearningCurveData}()},
\code{\link{generatePartialDependenceData}()},
\code{\link{generateThreshVsPerfData}()},
\code{\link{plotFilterValues}()}

Other filter: 
\code{\link{filterFeatures}()},
\code{\link{getFilteredFeatures}()},
\code{\link{listFilterEnsembleMethods}()},
\code{\link{listFilterMethods}()},
\code{\link{makeFilterEnsemble}()},
\code{\link{makeFilterWrapper}()},
\code{\link{makeFilter}()},
\code{\link{plotFilterValues}()}
}
\concept{filter}
\concept{generate_plot_data}
