% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMetrics.R
\name{tnr}
\alias{tnr}
\alias{specificity}
\title{Specificity, True negative rate}
\usage{
tnr(actual, predicted, cutoff = 0.5)
}
\arguments{
\item{actual}{A vector of the labels}

\item{predicted}{A vector of predicted values}

\item{cutoff}{A cutoff for the predicted values}
}
\description{
True Negatives / (True Negatives + False Positives)
}
\examples{
data(testDF)
glmModel <- glm(y ~ ., data = testDF, family="binomial")
Preds <- predict(glmModel, type = 'response')

tnr(testDF$y, Preds, cutoff = 0)
specificity(testDF$y, Preds, cutoff = 0)

}
