% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{run_tab}
\alias{run_tab}
\title{Tab for 'Word'}
\usage{
run_tab()
}
\description{
Object representing a tab
in a Word document. The result must be used
within a call to \link{fpar}. It will only have
effects in Word output.

Tabulation marks settings can be defined with \code{\link[=fp_tabs]{fp_tabs()}} in
paragraph settings defined with \code{\link[=fp_par]{fp_par()}}.
}
\section{usage}{

You can use this function in conjunction with \link{fpar} to create paragraphs
consisting of differently formatted text parts. You can also use this
function as an \emph{r chunk} in an R Markdown document made with package
officedown.
}

\examples{
z <- fp_tabs(
  fp_tab(pos = 0.5, style = "decimal"),
  fp_tab(pos = 1.5, style = "decimal")
)
par1 <- fpar(
  run_tab(), ftext("88."),
  run_tab(), ftext("987.45"),
  fp_p = fp_par(
    tabs = z
  )
)
par2 <- fpar(
  run_tab(), ftext("8."),
  run_tab(), ftext("670987.45"),
  fp_p = fp_par(
    tabs = z
  )
)
x <- read_docx()
x <- body_add(x, par1)
x <- body_add(x, par2)
print(x, target = tempfile(fileext = ".docx"))
}
\seealso{
Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_comment}()},
\code{\link{run_footnote}()},
\code{\link{run_footnoteref}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()},
\code{\link{run_wordtext}()}
}
\concept{run functions for reporting}
