% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval-information.R
\name{int_info}
\alias{int_info}
\alias{int_info.default}
\alias{int_info.data.frame}
\alias{int_info.ped}
\alias{int_info.pamm}
\title{Create start/end times and interval information}
\usage{
int_info(x, ...)

\method{int_info}{default}(x, min_time = 0L, ...)

\method{int_info}{data.frame}(x, min_time = 0L, ...)

\method{int_info}{ped}(x, ...)

\method{int_info}{pamm}(x, ...)
}
\arguments{
\item{x}{A numeric vector of cut points in which the follow-up should be
partitioned in or object of class \code{ped}.}

\item{...}{Currently ignored.}

\item{min_time}{Only intervals that have lower borders larger than
this value will be included in the resulting data frame.}
}
\value{
A data frame containing the start and end times of the
intervals specified by the \code{x} argument. Additionally, the interval
length, interval mid-point and a factor variable indicating the intervals.
}
\description{
Given interval breaks points, returns data frame with information on
interval start time, interval end time, interval length and a factor
variable indicating the interval (left open intervals). If an object of class
\code{ped} is provided, extracts unique interval information from object.
}
\examples{
## create interval information from cut points
int_info(c(1, 2.3, 5))

## extract interval information used to create ped object
tdf <- data.frame(time=c(1, 2.3, 5), status=c(0, 1, 0))
ped <- tdf \%>\% as_ped(Surv(time, status)~., id="id")
int_info(ped)

}
\seealso{
as_ped ped_info
}
\keyword{internal}
