% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_error.R
\name{standard_error}
\alias{standard_error}
\alias{standard_error.factor}
\alias{standard_error.default}
\alias{standard_error.merMod}
\alias{standard_error.glmmTMB}
\alias{standard_error.MixMod}
\alias{standard_error.zeroinfl}
\alias{standard_error.coxph}
\alias{standard_error.mixor}
\alias{standard_error.clm2}
\alias{standard_error.betareg}
\alias{standard_error.DirichletRegModel}
\title{Standard Errors}
\usage{
standard_error(model, ...)

\method{standard_error}{factor}(model, force = FALSE, verbose = TRUE, ...)

\method{standard_error}{default}(model, method = NULL, ...)

\method{standard_error}{merMod}(model, effects = c("fixed", "random"), method = NULL, ...)

\method{standard_error}{glmmTMB}(
  model,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated"),
  ...
)

\method{standard_error}{MixMod}(
  model,
  effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated"),
  ...
)

\method{standard_error}{zeroinfl}(
  model,
  component = c("all", "conditional", "zi", "zero_inflated"),
  method = NULL,
  ...
)

\method{standard_error}{coxph}(model, method = NULL, ...)

\method{standard_error}{mixor}(model, effects = c("all", "fixed", "random"), ...)

\method{standard_error}{clm2}(model, component = c("all", "conditional", "scale"), ...)

\method{standard_error}{betareg}(model, component = c("all", "conditional", "precision"), ...)

\method{standard_error}{DirichletRegModel}(model, component = c("all", "conditional", "precision"), ...)
}
\arguments{
\item{model}{A model.}

\item{...}{Arguments passed to or from other methods. For \code{standard_error()},
if \code{method = "robust"}, arguments \code{vcov_estimation}, \code{vcov_type}
and \code{vcov_args} can be passed down to \code{\link[=standard_error_robust]{standard_error_robust()}}.}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values to calculate the standard error, with the lowest level being the
value \code{1} (unless the factor has numeric levels, which are converted
to the corresponding numeric value). By default, \code{NA} is returned
for factors or character vectors.}

\item{verbose}{Toggle off warnings.}

\item{method}{If \code{"robust"}, robust standard errors are computed
by calling \code{\link[=standard_error_robust]{standard_error_robust()}}.
\code{standard_error_robust()}, in turn, calls one of the \code{vcov*()}-functions
from the \pkg{sandwich} or \pkg{clubSandwich} package for robust covariance
matrix estimators. For certain mixed models, \code{method} may also be one
of \code{"wald"}, \code{\link[=p_value_ml1]{"ml1"}}, \code{\link[=p_value_betwithin]{"betwithin"}},
\code{\link[=p_value_satterthwaite]{"satterthwaite"}} or \code{\link[=p_value_kenward]{"kenward"}}.}

\item{effects}{Should standard errors for fixed effects or random effects
be returned? Only applies to mixed models. May be abbreviated. When
standard errors for random effects are requested, for each grouping factor
a list of standard errors (per group level) for random intercepts and slopes
is returned.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}
}
\value{
A data frame.
}
\description{
\code{standard_error()} attempts to return standard errors of model parameters, while \code{standard_error_robust()} attempts to return robust standard errors.
}
\examples{
model <- lm(Petal.Length ~ Sepal.Length * Species, data = iris)
standard_error(model)
}
