% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_zmq_sendrecv_multipart.r
\name{Send Receive Multiple Raw Buffers}
\alias{Send Receive Multiple Raw Buffers}
\alias{zmq.send.multipart}
\alias{zmq.recv.multipart}
\title{Send Receive Multiple Raw Buffers}
\usage{
zmq.send.multipart(socket, parts, serialize = TRUE)

zmq.recv.multipart(socket, unserialize = TRUE)
}
\arguments{
\item{socket}{a ZMQ socket}

\item{parts}{a vector of multiple buffers to be sent}

\item{serialize, unserialize}{if serialize/unserialize the received multiple buffers}
}
\value{
\code{zmq.send.multipart()} returns.

\code{zmq.recv.multipart()} returns.
}
\description{
Send and receive functions for multiple raw buffers
}
\details{
\code{zmq.send.multipart()} is a high level R function to send multiple
raw messages \code{parts} at once.

\code{zmq.recv.multipart()} is a high level R function to receive multiple
raw messages at once.
}
\examples{
\dontrun{
### Using request-reply pattern.

### At the server, run next in background or the other window.
library(pbdZMQ, quietly = TRUE)

context <- zmq.ctx.new()
responder <- zmq.socket(context, ZMQ.ST()$REP)
zmq.bind(responder, "tcp://*:5555")

ret <- zmq.recv.multipart(responder, unserialize = TRUE)
parts <- as.list(rep("World", 5))
zmq.send.multipart(responder, parts)
for(i in 1:5) cat(ret[[i]])

zmq.close(responder)
zmq.ctx.destroy(context)

### At a client, run next in foreground.
library(pbdZMQ, quietly = TRUE)

context <- zmq.ctx.new()
requester <- zmq.socket(context, ZMQ.ST()$REQ)
zmq.connect(requester, "tcp://localhost:5555")

parts <- lapply(1:5, function(i.req){ paste("Sending Hello ", i.req, "\n") })
zmq.send.multipart(requester, parts)
ret <- zmq.recv.multipart(requester, unserialize = TRUE)
print(ret)

zmq.close(requester)
zmq.ctx.destroy(context)
}

}
\references{
ZeroMQ/4.1.0 API Reference:
\url{https://libzmq.readthedocs.io/en/zeromq4-1/}

Programming with Big Data in R Website: \url{https://pbdr.org/}
}
\seealso{
\code{\link{zmq.msg.send}()}, \code{\link{zmq.msg.recv}()}.
}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com}.
}
\keyword{programming}
