% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfg2gpc.R
\name{sfg2gpc}
\alias{sfg2gpc}
\title{Convert polygonal \code{"sfg"} to \code{"gpc.poly"}}
\usage{
sfg2gpc(object)
}
\arguments{
\item{object}{a \code{"POLYGON"} or \code{"MULTIPOLYGON"} \code{"sfg"} object.}
}
\value{
The converted polygon of class \code{"gpc.poly"}.
If package \pkg{gpclib} is not available,
\code{sfg2gpc} will just return the \code{pts} slot of the
\code{"gpc.poly"} (no formal class) with a warning.
}
\description{
Package \pkg{polyCub} implements a converter from class
\code{"\link[sf:st_polygon]{(MULTI)POLYGON}"} of package \CRANpkg{sf}
to \code{"gpc.poly"} of package \CRANpkg{gpclib}
such that \code{\link{polyCub.exact.Gauss}}
can be used with simple feature polygons.
}
\note{
Package \pkg{gpclib} is required for the formal class
definition of a \code{"gpc.poly"}.
}
\examples{
\dontshow{if (requireNamespace("sf")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## use example polygons from
example(plotpolyf, ask = FALSE)
letterR  # a simple "xylist"

letterR.sfg <- sf::st_polygon(lapply(letterR, function(xy)
    rbind(cbind(xy$x, xy$y), c(xy$x[1], xy$y[1]))))
letterR.sfg
stopifnot(identical(letterR, xylist(letterR.sfg)))
\dontshow{
stopifnot(identical(rep(letterR, 2),
    xylist(sf::st_multipolygon(list(letterR.sfg, letterR.sfg)))))
}
## convert sf "POLYGON" to a "gpc.poly"
letterR.gpc_from_sfg <- sfg2gpc(letterR.sfg)
letterR.gpc_from_sfg
\dontshow{
if (is(letterR.gpc_from_sfg, "gpc.poly") && requireNamespace("spatstat.geom")) {
    letterR.xylist_from_gpc <- xylist(letterR.gpc_from_sfg) # with hole info
    stopifnot(identical(letterR, lapply(letterR.xylist_from_gpc, `[`, 1:2)))
}}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{xylist}}
}
\author{
Sebastian Meyer
}
\keyword{methods}
\keyword{spatial}
