% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCarb-package.R
\docType{data}
\name{Example_Data}
\alias{Example_Data}
\title{Example data}
\format{
\code{Example_Data}: \link{data.frame} (28 x 29)

Each column has two attributes:
\itemize{
\item \code{UNIT}: the unit, so far applicable, e.g. "ppm"
\item \code{DESCRIPTION}: the column description
}
}
\description{
Example data as shipped with \emph{Carb} by Mauz \& Hoffmann (2014). In contrast to the original
data, \code{NA} values have been replaced by 0 and columns and rows have been transposed. Samples
are now organised in rows and parameters in columns.

The data can be used to test \code{'RCarb'} and play with the secondary carbonatisation process.
Sample HD107 was renamed to LV107 for the sake of consistency with Fig. 4 in Mauz \& Hoffmann (2014).
}
\section{Version}{
 0.1.0
}

\examples{

## show first elements of the example data
data(Example_Data, envir = environment())
head(Example_Data)

##show only column U230
Example_Data$U238

}
\references{
Mauz, B., Hoffmann, D., 2014. What to do when carbonate replaced water: Carb, the model
for estimating the dose rate of carbonate-rich samples. Ancient TL 32, 24-32.
}
\author{
Mauz \& Hoffmann (2014), with minor modifications by Sebastian Kreutzer,Geography & Earth
Sciences, Aberystwyth University (United Kingdom)
}
\keyword{datasets}
