% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_mode.R
\name{step_impute_mode}
\alias{step_impute_mode}
\alias{step_modeimpute}
\title{Impute nominal data using the most common value}
\usage{
step_impute_mode(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  modes = NULL,
  ptype = NULL,
  skip = FALSE,
  id = rand_id("impute_mode")
)

step_modeimpute(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  modes = NULL,
  ptype = NULL,
  skip = FALSE,
  id = rand_id("impute_mode")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{modes}{A named character vector of modes. This is
\code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{ptype}{A data frame prototype to cast new data sets to. This is
commonly a 0-row slice of the training set.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_impute_mode} creates a \emph{specification} of a
recipe step that will substitute missing values of nominal
variables by the training set mode of those variables.
}
\details{
\code{step_impute_mode} estimates the variable modes
from the data used in the \code{training} argument of
\code{prep.recipe}. \code{bake.recipe} then applies the new
values to new data sets using these values. If the training set
data has more than one mode, one is selected at random.

When you \code{\link[=tidy]{tidy()}} this step, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{model} (the mode
value) is returned.

As of \code{recipes} 0.1.16, this function name changed from \code{step_modeimpute()}
to \code{step_impute_mode()}.
}
\examples{
library(modeldata)
data("credit_data")

## missing data per column
vapply(credit_data, function(x) mean(is.na(x)), c(num = 0))

set.seed(342)
in_training <- sample(1:nrow(credit_data), 2000)

credit_tr <- credit_data[ in_training, ]
credit_te <- credit_data[-in_training, ]
missing_examples <- c(14, 394, 565)

rec <- recipe(Price ~ ., data = credit_tr)

impute_rec <- rec \%>\%
  step_impute_mode(Status, Home, Marital)

imp_models <- prep(impute_rec, training = credit_tr)

imputed_te <- bake(imp_models, new_data = credit_te, everything())

table(credit_te$Home, imputed_te$Home, useNA = "always")

tidy(impute_rec, number = 1)
tidy(imp_models, number = 1)
}
\seealso{
Other imputation steps: 
\code{\link{step_impute_bag}()},
\code{\link{step_impute_knn}()},
\code{\link{step_impute_linear}()},
\code{\link{step_impute_lower}()},
\code{\link{step_impute_mean}()},
\code{\link{step_impute_median}()},
\code{\link{step_impute_roll}()}
}
\concept{imputation steps}
