% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms-select.R
\name{terms_select}
\alias{terms_select}
\title{Select Terms in a Step Function.}
\usage{
terms_select(terms, info, empty_fun = abort_selection)
}
\arguments{
\item{terms}{A list of formulas whose right-hand side contains
quoted expressions. See \code{\link[rlang:nse-defuse]{rlang::quos()}} for examples.}

\item{info}{A tibble with columns \code{variable}, \code{type}, \code{role},
and \code{source} that represent the current state of the data. The
function \code{\link[=summary.recipe]{summary.recipe()}} can be used to get this information
from a recipe.}

\item{empty_fun}{A function to execute when no terms are selected by the
step. The default function throws an error with a message.}
}
\value{
A character string of column names or an error of there
are no selectors or if no variables are selected.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{terms_select()} has been deprecated in favor of \code{\link[=recipes_eval_select]{recipes_eval_select()}}.

This function bakes the step function selectors and might be
useful when creating custom steps.
}
\examples{
library(rlang)
library(modeldata)
data(okc)
rec <- recipe(~ ., data = okc)
info <- summary(rec)
terms_select(info = info, quos(all_predictors()))
}
\seealso{
\code{\link[=recipe]{recipe()}} \code{\link[=summary.recipe]{summary.recipe()}}
\code{\link[=prep.recipe]{prep.recipe()}}
}
\keyword{internal}
