% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parser.R
\docType{class}
\name{Parser-class}
\alias{Parser-class}
\alias{Parser}
\title{An RDF Parser object}
\description{
The Parser class provides methods to parse RDF content into a Redland
RDF model.
}
\section{Slots}{

\describe{
\item{\code{librdf_parser}}{A redland parser object}
}}

\section{Methods}{

\itemize{
\code{\link{Parser-initialize}}: Initialize a Parser object.
\code{\link{parseFileIntoModel}}: Parse the contents of a file into a model.
\code{\link{freeParser}}: Free memory used by a librdf parser.
}
}

\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
# Create the default "rdfxml" parser
parser <- new("Parser", world)
filePath <- system.file("extdata/example.rdf", package="redland")
parseFileIntoModel(parser, world, filePath, model)
}
\seealso{
\code{\link{redland}}: redland package
}
\keyword{classes}
