% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookarounds.R
\name{lookarounds}
\alias{lookarounds}
\alias{\%if_next_is\%}
\alias{\%if_next_isnt\%}
\alias{\%if_prev_is\%}
\alias{\%if_prev_isnt\%}
\title{Lookarounds}
\usage{
x \%if_next_is\% y

x \%if_next_isnt\% y

x \%if_prev_is\% y

x \%if_prev_isnt\% y
}
\arguments{
\item{x}{A regex pattern.}

\item{y}{A regex pattern.}
}
\description{
Lookarounds
}
\details{
These functions provide an interface to perl lookarounds.

Special binary functions are used to infer an ordering, since often you
might wish to match a word / set of characters conditional on the start
and end of that word.

\itemize{
  \item \code{\%if_next_is\%}: \code{TRUE} if x follows y
  \item \code{\%if_next_isnt\%}: \code{TRUE} if x does not follow y
  \item \code{\%if_prev_is\%}: \code{TRUE} if y comes before x
  \item \code{\%if_prev_isnt\%}: \code{TRUE} if y does not come before x
}
}
\examples{
stopifnot(grepl(rex("crab" \%if_next_is\% "apple"), "crabapple", perl = TRUE))
stopifnot(grepl(rex("crab" \%if_prev_is\% "apple"), "applecrab", perl = TRUE))
stopifnot(grepl(rex(range("a", "e") \%if_next_isnt\% range("f", "g")),
  "ah", perl = TRUE))
stopifnot(grepl(rex(range("a", "e") \%if_next_is\% range("f", "i")),
  "ah", perl = TRUE))
}
\seealso{
Perl 5 Documentation \url{https://perldoc.perl.org/perlre#Extended-Patterns}

Other rex: 
\code{\link{\%or\%}()},
\code{\link{capture}()},
\code{\link{character_class}()},
\code{\link{counts}},
\code{\link{group}()},
\code{\link{not}()},
\code{\link{rex}()},
\code{\link{shortcuts}},
\code{\link{wildcards}}
}
\concept{rex}
