% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{zap}
\alias{zap}
\alias{is_zap}
\title{Create zap objects}
\usage{
zap()

is_zap(x)
}
\arguments{
\item{x}{An object to test.}
}
\description{
\code{zap()} creates a sentinel object that indicates that an object
should be removed. For instance, named zaps instruct \code{\link[=env_bind]{env_bind()}}
and \code{\link[=call_modify]{call_modify()}} to remove those objects from the environment or
the call.

The advantage of zap objects is that they unambiguously signal the
intent of removing an object. Sentinels like \code{NULL} or
\code{\link[=missing_arg]{missing_arg()}} are ambiguous because they represent valid R
objects.
}
\examples{
# Create one zap object:
zap()

# Create a list of zaps:
rep(list(zap()), 3)
rep_named(c("foo", "bar"), list(zap()))
}
