% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{new_quosure}
\alias{new_quosure}
\alias{as_quosure}
\alias{is_quosure}
\title{Create a quosure from components}
\usage{
new_quosure(expr, env = caller_env())

as_quosure(x, env = NULL)

is_quosure(x)
}
\arguments{
\item{expr}{An expression to wrap in a quosure.}

\item{env}{The environment in which the expression should be
evaluated. Only used for symbols and calls. This should normally
be the environment in which the expression was created.}

\item{x}{An object to test.}
}
\description{
\itemize{
\item \code{new_quosure()} wraps any R object (including expressions,
formulas, or other quosures) into a \link[=topic-quosure]{quosure}.
\item \code{as_quosure()} is similar but it does not rewrap formulas and
quosures.
}
}
\examples{
# `new_quosure()` creates a quosure from its components. These are
# equivalent:
new_quosure(quote(foo), current_env())

quo(foo)

# `new_quosure()` always rewraps its input into a new quosure, even
# if the input is itself a quosure:
new_quosure(quo(foo))

# This is unlike `as_quosure()` which preserves its input if it's
# already a quosure:
as_quosure(quo(foo))


# `as_quosure()` uses the supplied environment with naked expressions:
env <- env(var = "thing")
as_quosure(quote(var), env)

# If the expression already carries an environment, this
# environment is preserved. This is the case for formulas and
# quosures:
as_quosure(~foo, env)

as_quosure(~foo)

# An environment must be supplied when the input is a naked
# expression:
try(
  as_quosure(quote(var))
)
}
\seealso{
\itemize{
\item \code{\link[=enquo]{enquo()}} and \code{\link[=quo]{quo()}} for creating a quosure by \link[=topic-defuse]{argument defusal}.
\item \ifelse{html}{\link[=topic-quosure]{What are quosures and when are they needed?}}{\link[=topic-quosure]{What are quosures and when are they needed?}}
}
}
