% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle-deprecated.R
\name{vector-coercion}
\alias{vector-coercion}
\alias{as_logical}
\alias{as_integer}
\alias{as_double}
\alias{as_complex}
\alias{as_character}
\alias{as_list}
\title{Coerce an object to a base type}
\usage{
as_logical(x)

as_integer(x)

as_double(x)

as_complex(x)

as_character(x, encoding = NULL)

as_list(x)
}
\arguments{
\item{x}{An object to coerce to a base type.}

\item{encoding}{If non-null, set an encoding mark. This is only
declarative, no encoding conversion is performed.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}

These are equivalent to the base functions (e.g. \code{\link[=as.logical]{as.logical()}},
\code{\link[=as.list]{as.list()}}, etc), but perform coercion rather than conversion.
This means they are not generic and will not call S3 conversion
methods. They only attempt to coerce the base type of their
input. In addition, they have stricter implicit coercion rules and
will never attempt any kind of parsing. E.g. they will not try to
figure out if a character vector represents integers or booleans.
Finally, they treat attributes consistently, unlike the base R
functions: all attributes except names are removed.
}
\section{Lifecycle}{


These functions are deprecated in favour of \code{vctrs::vec_cast()}.
}

\section{Coercion to logical and numeric atomic vectors}{

\itemize{
\item To logical vectors: Integer and integerish double vectors. See
\code{\link[=is_integerish]{is_integerish()}}.
\item To integer vectors: Logical and integerish double vectors.
\item To double vectors: Logical and integer vectors.
\item To complex vectors: Logical, integer and double vectors.
}
}

\section{Coercion to character vectors}{


\code{as_character()} and \code{as_string()} have an optional \code{encoding}
argument to specify the encoding. R uses this information for
internal handling of strings and character vectors. Note that this
is only declarative, no encoding conversion is attempted.

Note that only \code{as_string()} can coerce symbols to a scalar
character vector. This makes the code more explicit and adds an
extra type check.
}

\section{Coercion to lists}{


\code{as_list()} only coerces vector and dictionary types (environments
are an example of dictionary type). Unlike \code{\link[base:list]{base::as.list()}},
\code{as_list()} removes all attributes except names.
}

\section{Effects of removing attributes}{


A technical side-effect of removing the attributes of the input is
that the underlying objects has to be copied. This has no
performance implications in the case of lists because this is a
shallow copy: only the list structure is copied, not the contents
(see \code{\link[=duplicate]{duplicate()}}). However, be aware that atomic vectors
containing large amounts of data will have to be copied.

In general, any attribute modification creates a copy, which is why
it is better to avoid using attributes with heavy atomic vectors.
Uncopyable objects like environments and symbols are an exception
to this rule: in this case, attributes modification happens in
place and has side-effects.
}

\examples{
# Coercing atomic vectors removes attributes with both base R and rlang:
x <- structure(TRUE, class = "foo", bar = "baz")
as.logical(x)

# But coercing lists preserves attributes in base R but not rlang:
l <- structure(list(TRUE), class = "foo", bar = "baz")
as.list(l)
as_list(l)

# Implicit conversions are performed in base R but not rlang:
as.logical(l)
\dontrun{
as_logical(l)
}

# Conversion methods are bypassed, making the result of the
# coercion more predictable:
as.list.foo <- function(x) "wrong"
as.list(l)
as_list(l)

# The input is never parsed. E.g. character vectors of numbers are
# not converted to numeric types:
as.integer("33")
\dontrun{
as_integer("33")
}


# With base R tools there is no way to convert an environment to a
# list without either triggering method dispatch, or changing the
# original environment. as_list() makes it easy:
x <- structure(as_environment(mtcars[1:2]), class = "foobar")
as.list.foobar <- function(x) abort("dont call me")
as_list(x)
}
\keyword{internal}
