% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_match}
\alias{call_match}
\title{Match supplied arguments to function definition}
\usage{
call_match(
  call = NULL,
  fn = NULL,
  ...,
  defaults = FALSE,
  dots_env = NULL,
  dots_expand = TRUE
)
}
\arguments{
\item{call}{A call. The arguments will be matched to \code{fn}.}

\item{fn}{A function definition to match arguments to.}

\item{...}{These dots must be empty.}

\item{defaults}{Whether to match missing arguments to their
defaults.}

\item{dots_env}{An execution environment where to find dots. If
supplied and dots exist in this environment, and if \code{call}
includes \code{...}, the forwarded dots are matched to numbered dots
(e.g. \code{..1}, \code{..2}, etc). By default this is set to the empty
environment which means that \code{...} expands to nothing.}

\item{dots_expand}{If \code{FALSE}, arguments passed through \code{...} will
not be spliced into \code{call}. Instead, they are gathered in a
pairlist and assigned to an argument named \code{...}. Gathering dots
arguments is useful if you need to separate them from the other
named arguments.

Note that the resulting call is not meant to be evaluated since R
does not support passing dots through a named argument, even if
named \code{"..."}.}
}
\description{
\code{call_match()} is like \code{\link[=match.call]{match.call()}} with these differences:
\itemize{
\item It supports matching missing argument to their defaults in the
function definition.
\item It requires you to be a little more specific in some cases.
Either all arguments are inferred from the call stack or none of
them are (see the Inference section).
}
}
\section{Inference from the call stack}{

When \code{call} is not supplied, it is inferred from the call stack
along with \code{fn} and \code{dots_env}.
\itemize{
\item \code{call} and \code{fn} are inferred from the calling environment:
\code{sys.call(sys.parent())} and \code{sys.function(sys.parent())}.
\item \code{dots_env} is inferred from the caller of the calling
environment: \code{caller_env(2)}.
}

If \code{call} is supplied, then you must supply \code{fn} as well. Also
consider supplying \code{dots_env} as it is set to the empty environment
when not inferred.
}

\examples{
# `call_match()` supports matching missing arguments to their
# defaults
fn <- function(x = "default") fn
call_match(quote(fn()), fn)
call_match(quote(fn()), fn, defaults = TRUE)
}
