% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{stack}
\alias{stack}
\alias{current_call}
\alias{current_fn}
\alias{current_env}
\alias{caller_call}
\alias{caller_fn}
\alias{caller_env}
\alias{frame_call}
\alias{frame_fn}
\title{Get properties of the current or caller frame}
\usage{
current_call()

current_fn()

current_env()

caller_call(n = 1)

caller_fn(n = 1)

caller_env(n = 1)

frame_call(frame = caller_env())

frame_fn(frame = caller_env())
}
\arguments{
\item{n}{The number of callers to go back.}

\item{frame}{A frame environment of a currently running function,
as returned by \code{\link[=caller_env]{caller_env()}}. \code{NULL} is returned if the
environment does not exist on the stack.}
}
\description{
These accessors retrieve properties of frames on the call stack.
The prefix indicates for which frame a property should be accessed:
\itemize{
\item From the current frame with \code{current_} accessors.
\item From a calling frame with \code{caller_} accessors.
\item From a matching frame with \code{frame_} accessors.
}

The suffix indicates which property to retrieve:
\itemize{
\item \verb{_fn} accessors return the function running in the frame.
\item \verb{_call} accessors return the defused call with which the function
running in the frame was invoked.
\item \verb{_env} accessors return the execution environment of the function
running in the frame.
}
}
\seealso{
\code{\link[=caller_env]{caller_env()}} and \code{\link[=current_env]{current_env()}}
}
