% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.group.R
\name{list.ungroup}
\alias{list.ungroup}
\title{Ungroup a list by taking out second-level elements}
\usage{
list.ungroup(.data, level = 1L, ..., group.names = FALSE,
  sort.names = FALSE)
}
\arguments{
\item{.data}{\code{list}}

\item{level}{{integer} to indicate to which level of list elements
should be ungroupped to the first level.}

\item{...}{Preserved use of parameter passing}

\item{group.names}{\code{logical}. Should the group names be
preserved?}

\item{sort.names}{\code{logical}. Should the members be sorted
after ungrouping?}
}
\description{
This functon reverses the grouping operation by taking out
second-level elements of a nested list and removing the labels
of the first-level elements. For example, a list may be created
from paged data, that is, its first-level elements only indicate
the page container. To unpage the list, the first-level elements
must be removed and their inner elements should be taken out to
to the first level.
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
xg <- list.group(x, type)
list.ungroup(xg)

x <- list(a = list(a1 = list(x=list(x1=2,x2=3),y=list(y1=1,y2=3))),
       b = list(b1 = list(x=list(x1=2,x2=6),y=list(y1=3,y2=2))))
list.ungroup(x, level = 1)
list.ungroup(x, level = 2)
list.ungroup(x, level = 2, group.names = TRUE)
}
\seealso{
\code{\link{list.group}}
}

