% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{New}
\alias{New}
\title{new with namespaced class name}
\usage{
New(Class, ...)
}
\arguments{
\item{Class}{the name of the S4 class to be instantiated}

\item{...}{additional parameters for \code{methods::new()}}
}
\description{
Convenience function for \code{\link[methods:new]{methods::new()}} that ensures that the provided
class name is namespaced with a package name.
}
\details{
If the provided class name is not already namespaced (see
\code{methods::packageSlot()}), it will be namespaced with this package. This
mechanism is used by \code{new()} to disambiguate if the class name clashes
with a class defined in another package.
}
\note{
This may not completely eliminate messages on standard error about
classes with the same name having been found in different packages. If
they appear, they will most likely have come from the call to the
\code{methods::initialize()} generic that \code{new()} issues at the end.
}
