% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_dataset.R
\name{writeDatasets}
\alias{writeDatasets}
\title{Write Multiple Datasets}
\usage{
writeDatasets(
  datasets,
  file,
  ...,
  append = FALSE,
  quote = TRUE,
  sep = ",",
  eol = "\\n",
  na = "NA",
  dec = ".",
  row.names = TRUE,
  col.names = NA,
  qmethod = "double",
  fileEncoding = "UTF-8"
)
}
\arguments{
\item{datasets}{A list of datasets.}

\item{file}{The target CSV file.}

\item{...}{Further arguments to be passed to \code{\link[utils]{write.table}}.}

\item{append}{Logical. Only relevant if file is a character string.
If \code{TRUE}, the output is appended to the file. If FALSE, any existing file of the name is destroyed.}

\item{quote}{The set of quoting characters. To disable quoting altogether, use
quote = "". See scan for the behavior on quotes embedded in quotes. Quoting is only
considered for columns read as character, which is all of them unless \code{colClasses} is specified.}

\item{sep}{The field separator character. Values on each line of the file are separated
by this character. If sep = "," (the default for \code{writeDatasets}) the separator is a comma.}

\item{eol}{The character(s) to print at the end of each line (row).}

\item{na}{The string to use for missing values in the data.}

\item{dec}{The character used in the file for decimal points.}

\item{row.names}{Either a logical value indicating whether the row names of \code{dataset} are
to be written along with  \code{dataset}, or a character vector of row names to be written.}

\item{col.names}{Either a logical value indicating whether the column names of  \code{dataset} are
to be written along with  \code{dataset}, or a character vector of column names to be written.
See the section on 'CSV files' for the meaning of \code{col.names = NA}.}

\item{qmethod}{A character string specifying how to deal with embedded double quote characters
when quoting strings. Must be one of "double" (default in \code{writeDatasets}) or "escape".}

\item{fileEncoding}{Character string: if non-empty declares the encoding used on a file
(not a connection) so the character data can be re-encoded.
See the 'Encoding' section of the help for file, the 'R Data Import/Export Manual' and 'Note'.}
}
\description{
Writes a list of datasets to a CSV file.
}
\details{
The format of the CSV file is optimized for usage of \code{\link[=readDatasets]{readDatasets()}}.
}
\examples{
\dontrun{
d1 <- getDataset(
    n1 = c(11, 13, 12, 13),
    n2 = c(8, 10, 9, 11),
    events1 = c(10, 10, 12, 12),
    events2 = c(3, 5, 5, 6)
)
d2 <- getDataset(
    n1 = c(9, 13, 12, 13),
    n2 = c(6, 10, 9, 11),
    events1 = c(10, 10, 12, 12),
    events2 = c(4, 5, 5, 6)
)
datasets <- list(d1, d2)
writeDatasets(datasets, "datasets_rates.csv")
}

}
\seealso{
\itemize{
\item \code{\link[=writeDataset]{writeDataset()}} for writing a single dataset,
\item \code{\link[=readDatasets]{readDatasets()}} for reading multiple datasets,
\item \code{\link[=readDataset]{readDataset()}} for reading a single dataset.
}
}
