% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{auth_save}
\alias{auth_save}
\alias{auth_list}
\title{Save an authentication mechanism for use in a future session}
\usage{
auth_save(auth, name)

auth_list()
}
\arguments{
\item{auth}{One of \code{\link[=rtweet_app]{rtweet_app()}}, \code{\link[=rtweet_bot]{rtweet_bot()}}, or \code{\link[=rtweet_user]{rtweet_user()}}.}

\item{name}{Name of the file to use.}
}
\value{
Invisible the path where the authentication is saved.
}
\description{
Use \code{auth_save()} with \code{\link[=auth_as]{auth_as()}} to avoid repeatedly entering app
credentials, making it easier to share auth between projects.
Use \code{auth_list()} to list all saved credentials.
}
\details{
The tokens are saved on \code{tools::R_user_dir("rtweet", "config")}.
}
\examples{
\dontrun{
# save app auth for use in other sessions
auth <- rtweet_app()
auth_save(auth, "my-app")

# later, in a different session...
auth_as("my-app")
# Show all authentications stored
auth_list()
}
}
\seealso{
\code{\link[=auth_sitrep]{auth_sitrep()}} to help finding and managing authentications.

Other authentication: 
\code{\link{auth_as}()},
\code{\link{auth_get}()},
\code{\link{auth_setup_default}()},
\code{\link{rtweet_user}()}
}
\concept{authentication}
