% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-percent.R
\name{label_percent}
\alias{label_percent}
\alias{percent_format}
\alias{percent}
\title{Label percentages (2.5\%, 50\%, etc)}
\usage{
label_percent(accuracy = NULL, scale = 100, prefix = "",
  suffix = "\%", big.mark = " ", decimal.mark = ".", trim = TRUE,
  ...)

percent_format(accuracy = NULL, scale = 100, prefix = "",
  suffix = "\%", big.mark = " ", decimal.mark = ".", trim = TRUE,
  ...)

percent(x, accuracy = NULL, scale = 100, prefix = "",
  suffix = "\%", big.mark = " ", decimal.mark = ".", trim = TRUE,
  ...)
}
\arguments{
\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formating. This is useful if the underlying data is very small or very
large.}

\item{prefix}{Symbols to display before and after value.}

\item{suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{x}{A numeric vector to format.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Label percentages (2.5\%, 50\%, etc)
}
\section{Old interface}{

\code{percent()} and \code{percent_format()} are retired; please use \code{label_percent()}
instead.
}

\examples{
demo_continuous(c(0, 1))
demo_continuous(c(0, 1), labels = label_percent())

# Use prefix and suffix to create your own variants
french_percent <- label_percent(
  decimal.mark = ",",
  suffix = " \%"
)
demo_continuous(c(0, .01), labels = french_percent)
}
\seealso{
Other labels for continuous scales: \code{\link{label_bytes}},
  \code{\link{label_dollar}},
  \code{\link{label_number_auto}},
  \code{\link{label_number_si}},
  \code{\link{label_ordinal}}, \code{\link{label_parse}},
  \code{\link{label_pvalue}},
  \code{\link{label_scientific}}
}
\concept{labels for continuous scales}
