% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CollapseEmbeddingOutliers}
\alias{CollapseEmbeddingOutliers}
\title{Move outliers towards center on dimension reduction plot}
\usage{
CollapseEmbeddingOutliers(
  object,
  reduction = "umap",
  dims = 1:2,
  group.by = "ident",
  outlier.sd = 2,
  reduction.key = "UMAP_"
)
}
\arguments{
\item{object}{Seurat object}

\item{reduction}{Name of DimReduc to adjust}

\item{dims}{Dimensions to visualize}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident)}

\item{outlier.sd}{Controls the outlier distance}

\item{reduction.key}{Key for DimReduc that is returned}
}
\value{
Returns a DimReduc object with the modified embeddings
}
\description{
Move outliers towards center on dimension reduction plot
}
\examples{
\dontrun{
pbmc_small <- FindClusters(pbmc_small, resolution = 1.1)
pbmc_small <- RunUMAP(pbmc_small, dims = 1:5)
DimPlot(pbmc_small, reduction = "umap")
pbmc_small[["umap_new"]] <- CollapseEmbeddingOutliers(pbmc_small,
    reduction = "umap", reduction.key = 'umap_', outlier.sd = 0.5)
DimPlot(pbmc_small, reduction = "umap_new")
}

}
