% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{SubsetByBarcodeInflections}
\alias{SubsetByBarcodeInflections}
\title{Subset a Seurat Object based on the Barcode Distribution Inflection Points}
\usage{
SubsetByBarcodeInflections(object)
}
\arguments{
\item{object}{Seurat object}
}
\value{
Returns a subsetted Seurat object.
}
\description{
This convenience function subsets a Seurat object based on calculated inflection points.
}
\details{
See [CalculateBarcodeInflections()] to calculate inflection points and
[BarcodeInflectionsPlot()] to visualize and test inflection point calculations.
}
\examples{
pbmc_small <- CalculateBarcodeInflections(
  object = pbmc_small,
  group.column = 'groups',
  threshold.low = 20,
  threshold.high = 30
)
SubsetByBarcodeInflections(object = pbmc_small)

}
\seealso{
\code{\link{CalculateBarcodeInflections}} \code{\link{BarcodeInflectionsPlot}}
}
\author{
Robert A. Amezquita, \email{robert.amezquita@fredhutch.org}
}
