% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{st_join}
\alias{st_join}
\alias{st_join.sf}
\alias{st_filter}
\alias{st_filter.sf}
\title{spatial join, spatial filter}
\usage{
st_join(x, y, join, ...)

\method{st_join}{sf}(
  x,
  y,
  join = st_intersects,
  ...,
  suffix = c(".x", ".y"),
  left = TRUE,
  largest = FALSE
)

st_filter(x, y, ...)

\method{st_filter}{sf}(x, y, ..., .predicate = st_intersects)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{y}{object of class \code{sf}}

\item{join}{geometry predicate function with the same profile as \link{st_intersects}; see details}

\item{...}{for \code{st_join}: arguments passed on to the \code{join} function or to \code{st_intersection} when \code{largest} is \code{TRUE}; for \code{st_filter} arguments passed on to the \code{.predicate} function, e.g. \code{prepared}, or a pattern for \link{st_relate}}

\item{suffix}{length 2 character vector; see \link[base]{merge}}

\item{left}{logical; if \code{TRUE} return the left join, otherwise an inner join; see details.
see also \link[dplyr:mutate-joins]{left_join}}

\item{largest}{logical; if \code{TRUE}, return \code{x} features augmented with the fields of \code{y} that have the largest overlap with each of the features of \code{x}; see https://github.com/r-spatial/sf/issues/578}

\item{.predicate}{geometry predicate function with the same profile as \link{st_intersects}; see details}
}
\value{
an object of class \code{sf}, joined based on geometry
}
\description{
spatial join, spatial filter
}
\details{
alternative values for argument \code{join} are:
\itemize{
\item \link{st_contains_properly},
\item \link{st_contains},
\item \link{st_covered_by},
\item \link{st_covers},
\item \link{st_crosses},
\item \link{st_disjoint},
\item \link{st_equals_exact},
\item \link{st_equals},
\item \link{st_is_within_distance},
\item \link{st_nearest_feature},
\item \link{st_overlaps},
\item \link{st_touches},
\item \link{st_within},
\item \link{st_relate} (which will require \code{pattern} to be set),
\item or any user-defined function of the same profile as the above
}
A left join returns all records of the \code{x} object with \code{y} fields for non-matched records filled with \code{NA} values; an inner join returns only records that spatially match.

To replicate the results of \code{st_within(x, y)} you will need to use \code{st_join(x, y, join = "st_within", left = FALSE)}.
}
\examples{
a = st_sf(a = 1:3,
 geom = st_sfc(st_point(c(1,1)), st_point(c(2,2)), st_point(c(3,3))))
b = st_sf(a = 11:14,
 geom = st_sfc(st_point(c(10,10)), st_point(c(2,2)), st_point(c(2,2)), st_point(c(3,3))))
st_join(a, b)
st_join(a, b, left = FALSE)
# two ways to aggregate y's attribute values outcome over x's geometries:
st_join(a, b) \%>\% aggregate(list(.$a.x), mean)
if (require(dplyr, quietly = TRUE)) {
 st_join(a, b) \%>\% group_by(a.x) \%>\% summarise(mean(a.y))
}
# example of largest = TRUE:
nc <- st_transform(st_read(system.file("shape/nc.shp", package="sf")), 2264)                
gr = st_sf(
    label = apply(expand.grid(1:10, LETTERS[10:1])[,2:1], 1, paste0, collapse = " "),
    geom = st_make_grid(st_as_sfc(st_bbox(nc))))
gr$col = sf.colors(10, categorical = TRUE, alpha = .3)
# cut, to check, NA's work out:
gr = gr[-(1:30),]
nc_j <- st_join(nc, gr, largest = TRUE)
# the two datasets:
opar = par(mfrow = c(2,1), mar = rep(0,4))
plot(st_geometry(nc_j))
plot(st_geometry(gr), add = TRUE, col = gr$col)
text(st_coordinates(st_centroid(gr)), labels = gr$label)
# the joined dataset:
plot(st_geometry(nc_j), border = 'black', col = nc_j$col)
text(st_coordinates(st_centroid(nc_j)), labels = nc_j$label, cex = .8)
plot(st_geometry(gr), border = 'green', add = TRUE)
par(opar)
# st_filter keeps the geometries in x where .predicate(x,y) returns any match in y for x
st_filter(a, b)
# for an anti-join, use the union of y
st_filter(a, st_union(b), .predicate = st_disjoint)
}
